/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.command.executable.authme.debug;

import ch.jalu.injector.factory.Factory;
import com.google.common.collect.ImmutableSet;
import fr.xephi.authme.command.ExecutableCommand;
import fr.xephi.authme.command.executable.authme.debug.CountryLookup;
import fr.xephi.authme.command.executable.authme.debug.DataStatistics;
import fr.xephi.authme.command.executable.authme.debug.DebugSection;
import fr.xephi.authme.command.executable.authme.debug.HasPermissionChecker;
import fr.xephi.authme.command.executable.authme.debug.InputValidator;
import fr.xephi.authme.command.executable.authme.debug.LimboPlayerViewer;
import fr.xephi.authme.command.executable.authme.debug.MySqlDefaultChanger;
import fr.xephi.authme.command.executable.authme.debug.PermissionGroups;
import fr.xephi.authme.command.executable.authme.debug.PlayerAuthViewer;
import fr.xephi.authme.command.executable.authme.debug.SpawnLocationViewer;
import fr.xephi.authme.command.executable.authme.debug.TestEmailSender;
import fr.xephi.authme.permission.PermissionsManager;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.inject.Inject;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class DebugCommand
implements ExecutableCommand {
    private static final Set<Class<? extends DebugSection>> SECTION_CLASSES = ImmutableSet.of(PermissionGroups.class, DataStatistics.class, CountryLookup.class, PlayerAuthViewer.class, InputValidator.class, LimboPlayerViewer.class, (Object[])new Class[]{CountryLookup.class, HasPermissionChecker.class, TestEmailSender.class, SpawnLocationViewer.class, MySqlDefaultChanger.class});
    @Inject
    private Factory<DebugSection> debugSectionFactory;
    @Inject
    private PermissionsManager permissionsManager;
    private Map<String, DebugSection> sections;

    @Override
    public void executeCommand(CommandSender sender, List<String> arguments) {
        DebugSection debugSection = this.findDebugSection(arguments);
        if (debugSection == null) {
            this.sendAvailableSections(sender);
        } else {
            this.executeSection(debugSection, sender, arguments);
        }
    }

    private DebugSection findDebugSection(List<String> arguments) {
        if (arguments.isEmpty()) {
            return null;
        }
        return this.getSections().get(arguments.get(0).toLowerCase(Locale.ROOT));
    }

    private void sendAvailableSections(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.BLUE) + "AuthMe debug utils");
        sender.sendMessage("Sections available to you:");
        long availableSections = this.getSections().values().stream().filter(section -> this.permissionsManager.hasPermission(sender, section.getRequiredPermission())).peek(e -> sender.sendMessage("- " + e.getName() + ": " + e.getDescription())).count();
        if (availableSections == 0L) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to view any debug section");
        }
    }

    private void executeSection(DebugSection section, CommandSender sender, List<String> arguments) {
        if (this.permissionsManager.hasPermission(sender, section.getRequiredPermission())) {
            section.execute(sender, arguments.subList(1, arguments.size()));
        } else {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission for this section. See /authme debug");
        }
    }

    private Map<String, DebugSection> getSections() {
        if (this.sections == null) {
            TreeMap<String, DebugSection> sections = new TreeMap<String, DebugSection>();
            for (Class<? extends DebugSection> sectionClass : SECTION_CLASSES) {
                DebugSection section = (DebugSection)this.debugSectionFactory.newInstance(sectionClass);
                sections.put(section.getName(), section);
            }
            this.sections = sections;
        }
        return this.sections;
    }
}

