/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.command.executable.authme;

import com.google.common.annotations.VisibleForTesting;
import fr.xephi.authme.command.ExecutableCommand;
import fr.xephi.authme.data.auth.PlayerAuth;
import fr.xephi.authme.datasource.DataSource;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import javax.inject.Inject;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class RecentPlayersCommand
implements ExecutableCommand {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("hh:mm a, dd MMM");
    @Inject
    private DataSource dataSource;

    @Override
    public void executeCommand(CommandSender sender, List<String> arguments) {
        List<PlayerAuth> recentPlayers = this.dataSource.getRecentlyLoggedInPlayers();
        sender.sendMessage(String.valueOf(ChatColor.BLUE) + "[AuthMe] Recently logged in players");
        for (PlayerAuth auth : recentPlayers) {
            sender.sendMessage(this.formatPlayerMessage(auth));
        }
    }

    @VisibleForTesting
    ZoneId getZoneId() {
        return ZoneId.systemDefault();
    }

    private String formatPlayerMessage(PlayerAuth auth) {
        String lastLoginText;
        if (auth.getLastLogin() == null) {
            lastLoginText = "never";
        } else {
            LocalDateTime lastLogin = LocalDateTime.ofInstant(Instant.ofEpochMilli(auth.getLastLogin()), this.getZoneId());
            lastLoginText = DATE_FORMAT.format(lastLogin);
        }
        return "- " + auth.getRealName() + " (" + lastLoginText + " with IP " + auth.getLastIp() + ")";
    }
}

