/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.command.executable.authme;

import fr.xephi.authme.command.ExecutableCommand;
import fr.xephi.authme.data.auth.PlayerAuth;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.message.MessageKey;
import fr.xephi.authme.service.CommonService;
import java.util.List;
import javax.inject.Inject;
import org.bukkit.command.CommandSender;

public class PurgeLastPositionCommand
implements ExecutableCommand {
    @Inject
    private DataSource dataSource;
    @Inject
    private CommonService commonService;

    @Override
    public void executeCommand(CommandSender sender, List<String> arguments) {
        String playerName;
        String string = playerName = arguments.isEmpty() ? sender.getName() : arguments.get(0);
        if ("*".equals(playerName)) {
            for (PlayerAuth auth : this.dataSource.getAllAuths()) {
                PurgeLastPositionCommand.resetLastPosition(auth);
                this.dataSource.updateQuitLoc(auth);
            }
            sender.sendMessage("All players last position locations are now reset");
        } else {
            PlayerAuth auth = this.dataSource.getAuth(playerName);
            if (auth == null) {
                this.commonService.send(sender, MessageKey.UNKNOWN_USER);
                return;
            }
            PurgeLastPositionCommand.resetLastPosition(auth);
            this.dataSource.updateQuitLoc(auth);
            sender.sendMessage(playerName + "'s last position location is now reset");
        }
    }

    private static void resetLastPosition(PlayerAuth auth) {
        auth.setQuitLocX(0.0);
        auth.setQuitLocY(0.0);
        auth.setQuitLocZ(0.0);
        auth.setWorld("world");
    }
}

