/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.command.executable.authme;

import com.google.common.primitives.Ints;
import fr.xephi.authme.command.ExecutableCommand;
import fr.xephi.authme.task.purge.PurgeService;
import java.util.Calendar;
import java.util.List;
import javax.inject.Inject;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class PurgeCommand
implements ExecutableCommand {
    private static final int MINIMUM_LAST_SEEN_DAYS = 30;
    @Inject
    private PurgeService purgeService;

    @Override
    public void executeCommand(CommandSender sender, List<String> arguments) {
        String daysStr = arguments.get(0);
        Integer days = Ints.tryParse((String)daysStr);
        if (days == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "The value you've entered is invalid!");
            return;
        }
        if (days < 30) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You can only purge data older than 30 days");
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -days.intValue());
        long until = calendar.getTimeInMillis();
        this.purgeService.runPurge(sender, until);
    }
}

