/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.command.executable.authme;

import fr.xephi.authme.command.ExecutableCommand;
import fr.xephi.authme.service.BukkitService;
import fr.xephi.authme.task.purge.PurgeService;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.inject.Inject;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;

public class PurgeBannedPlayersCommand
implements ExecutableCommand {
    @Inject
    private PurgeService purgeService;
    @Inject
    private BukkitService bukkitService;

    @Override
    public void executeCommand(CommandSender sender, List<String> arguments) {
        Set<OfflinePlayer> bannedPlayers = this.bukkitService.getBannedPlayers();
        HashSet<String> namedBanned = new HashSet<String>(bannedPlayers.size());
        for (OfflinePlayer offlinePlayer : bannedPlayers) {
            namedBanned.add(offlinePlayer.getName().toLowerCase(Locale.ROOT));
        }
        this.purgeService.purgePlayers(sender, namedBanned, bannedPlayers.toArray(new OfflinePlayer[bannedPlayers.size()]));
    }
}

