/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.command.executable.authme;

import fr.xephi.authme.command.ExecutableCommand;
import fr.xephi.authme.permission.PermissionsManager;
import fr.xephi.authme.permission.PlayerPermission;
import fr.xephi.authme.process.Management;
import fr.xephi.authme.service.BukkitService;
import java.util.List;
import javax.inject.Inject;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ForceLoginCommand
implements ExecutableCommand {
    @Inject
    private PermissionsManager permissionsManager;
    @Inject
    private Management management;
    @Inject
    private BukkitService bukkitService;

    @Override
    public void executeCommand(CommandSender sender, List<String> arguments) {
        String playerName = arguments.isEmpty() ? sender.getName() : arguments.get(0);
        Player player = this.bukkitService.getPlayerExact(playerName);
        if (player == null || !player.isOnline()) {
            sender.sendMessage("Player needs to be online!");
        } else if (!this.permissionsManager.hasPermission((CommandSender)player, PlayerPermission.CAN_LOGIN_BE_FORCED)) {
            sender.sendMessage("You cannot force login the player " + playerName + "!");
        } else {
            this.management.forceLogin(player);
            sender.sendMessage("Force login for " + playerName + " performed!");
        }
    }
}

