/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.command.executable.authme;

import ch.jalu.injector.factory.Factory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSortedMap;
import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.command.ExecutableCommand;
import fr.xephi.authme.datasource.converter.Converter;
import fr.xephi.authme.datasource.converter.CrazyLoginConverter;
import fr.xephi.authme.datasource.converter.LoginSecurityConverter;
import fr.xephi.authme.datasource.converter.MySqlToSqlite;
import fr.xephi.authme.datasource.converter.RakamakConverter;
import fr.xephi.authme.datasource.converter.RoyalAuthConverter;
import fr.xephi.authme.datasource.converter.SqliteToSql;
import fr.xephi.authme.datasource.converter.VAuthConverter;
import fr.xephi.authme.datasource.converter.XAuthConverter;
import fr.xephi.authme.message.MessageKey;
import fr.xephi.authme.output.ConsoleLoggerFactory;
import fr.xephi.authme.service.BukkitService;
import fr.xephi.authme.service.CommonService;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import org.bukkit.command.CommandSender;

public class ConverterCommand
implements ExecutableCommand {
    @VisibleForTesting
    static final Map<String, Class<? extends Converter>> CONVERTERS = ConverterCommand.getConverters();
    private final ConsoleLogger logger = ConsoleLoggerFactory.get(ConverterCommand.class);
    @Inject
    private CommonService commonService;
    @Inject
    private BukkitService bukkitService;
    @Inject
    private Factory<Converter> converterFactory;

    @Override
    public void executeCommand(CommandSender sender, List<String> arguments) {
        Class<? extends Converter> converterClass = ConverterCommand.getConverterClassFromArgs(arguments);
        if (converterClass == null) {
            sender.sendMessage("Converters: " + String.join((CharSequence)", ", CONVERTERS.keySet()));
            return;
        }
        Converter converter = (Converter)this.converterFactory.newInstance(converterClass);
        this.bukkitService.runTaskAsynchronously(() -> {
            try {
                converter.execute(sender);
            }
            catch (Exception e) {
                this.commonService.send(sender, MessageKey.ERROR);
                this.logger.logException("Error during conversion:", e);
            }
        });
        sender.sendMessage("[AuthMe] Successfully started " + arguments.get(0));
    }

    private static Class<? extends Converter> getConverterClassFromArgs(List<String> arguments) {
        return arguments.isEmpty() ? null : CONVERTERS.get(arguments.get(0).toLowerCase(Locale.ROOT));
    }

    private static Map<String, Class<? extends Converter>> getConverters() {
        return ImmutableSortedMap.naturalOrder().put((Object)"xauth", XAuthConverter.class).put((Object)"crazylogin", CrazyLoginConverter.class).put((Object)"rakamak", RakamakConverter.class).put((Object)"royalauth", RoyalAuthConverter.class).put((Object)"vauth", VAuthConverter.class).put((Object)"sqlitetosql", SqliteToSql.class).put((Object)"mysqltosqlite", MySqlToSqlite.class).put((Object)"loginsecurity", LoginSecurityConverter.class).build();
    }
}

