/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.command;

import com.google.common.base.Preconditions;
import fr.xephi.authme.command.CommandArgumentDescription;
import fr.xephi.authme.command.ExecutableCommand;
import fr.xephi.authme.permission.PermissionNode;
import fr.xephi.authme.util.StringUtils;
import fr.xephi.authme.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CommandDescription {
    private List<String> labels;
    private String description;
    private String detailedDescription;
    private Class<? extends ExecutableCommand> executableCommand;
    private CommandDescription parent;
    private List<CommandDescription> children = new ArrayList<CommandDescription>();
    private List<CommandArgumentDescription> arguments;
    private PermissionNode permission;

    private CommandDescription(List<String> labels, String description, String detailedDescription, Class<? extends ExecutableCommand> executableCommand, CommandDescription parent, List<CommandArgumentDescription> arguments, PermissionNode permission) {
        this.labels = labels;
        this.description = description;
        this.detailedDescription = detailedDescription;
        this.executableCommand = executableCommand;
        this.parent = parent;
        this.arguments = arguments;
        this.permission = permission;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public boolean hasLabel(String commandLabel) {
        for (String label : this.labels) {
            if (!label.equalsIgnoreCase(commandLabel)) continue;
            return true;
        }
        return false;
    }

    public Class<? extends ExecutableCommand> getExecutableCommand() {
        return this.executableCommand;
    }

    public CommandDescription getParent() {
        return this.parent;
    }

    public int getLabelCount() {
        if (this.parent == null) {
            return 1;
        }
        return this.parent.getLabelCount() + 1;
    }

    public List<CommandDescription> getChildren() {
        return this.children;
    }

    public List<CommandArgumentDescription> getArguments() {
        return this.arguments;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDetailedDescription() {
        return this.detailedDescription;
    }

    public PermissionNode getPermission() {
        return this.permission;
    }

    public static CommandBuilder builder() {
        return new CommandBuilder();
    }

    public static final class CommandBuilder {
        private List<String> labels;
        private String description;
        private String detailedDescription;
        private Class<? extends ExecutableCommand> executableCommand;
        private CommandDescription parent;
        private List<CommandArgumentDescription> arguments = new ArrayList<CommandArgumentDescription>();
        private PermissionNode permission;

        public CommandDescription register() {
            CommandDescription command = this.build();
            if (command.parent != null) {
                command.parent.children.add(command);
            }
            return command;
        }

        public CommandDescription build() {
            Preconditions.checkArgument((!Utils.isCollectionEmpty(this.labels) ? 1 : 0) != 0, (Object)"Labels may not be empty");
            Preconditions.checkArgument((!StringUtils.isBlank(this.description) ? 1 : 0) != 0, (Object)"Description may not be empty");
            Preconditions.checkArgument((!StringUtils.isBlank(this.detailedDescription) ? 1 : 0) != 0, (Object)"Detailed description may not be empty");
            Preconditions.checkArgument((this.executableCommand != null ? 1 : 0) != 0, (Object)"Executable command must be set");
            return new CommandDescription(this.labels, this.description, this.detailedDescription, this.executableCommand, this.parent, this.arguments, this.permission);
        }

        public CommandBuilder labels(List<String> labels) {
            this.labels = labels;
            return this;
        }

        public CommandBuilder labels(String ... labels) {
            return this.labels(Arrays.asList(labels));
        }

        public CommandBuilder description(String description) {
            this.description = description;
            return this;
        }

        public CommandBuilder detailedDescription(String detailedDescription) {
            this.detailedDescription = detailedDescription;
            return this;
        }

        public CommandBuilder executableCommand(Class<? extends ExecutableCommand> executableCommand) {
            this.executableCommand = executableCommand;
            return this;
        }

        public CommandBuilder parent(CommandDescription parent) {
            this.parent = parent;
            return this;
        }

        public CommandBuilder withArgument(String label, String description, boolean isOptional) {
            this.arguments.add(new CommandArgumentDescription(label, description, isOptional));
            return this;
        }

        public CommandBuilder permission(PermissionNode permission) {
            this.permission = permission;
            return this;
        }
    }
}

