/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.api.v3;

import fr.xephi.authme.api.v3.AuthMePlayer;
import fr.xephi.authme.data.auth.PlayerAuth;
import java.time.Instant;
import java.util.Optional;
import java.util.UUID;

class AuthMePlayerImpl
implements AuthMePlayer {
    private String name;
    private UUID uuid;
    private String email;
    private Instant registrationDate;
    private String registrationIpAddress;
    private Instant lastLoginDate;
    private String lastLoginIpAddress;

    AuthMePlayerImpl() {
    }

    static Optional<AuthMePlayer> fromPlayerAuth(PlayerAuth playerAuth) {
        if (playerAuth == null) {
            return Optional.empty();
        }
        AuthMePlayerImpl authMeUser = new AuthMePlayerImpl();
        authMeUser.name = playerAuth.getRealName();
        authMeUser.uuid = playerAuth.getUuid();
        authMeUser.email = AuthMePlayerImpl.nullIfDefault(playerAuth.getEmail(), "your@email.com");
        Long lastLoginMillis = AuthMePlayerImpl.nullIfDefault(playerAuth.getLastLogin(), 0L);
        authMeUser.registrationDate = AuthMePlayerImpl.toInstant(playerAuth.getRegistrationDate());
        authMeUser.registrationIpAddress = playerAuth.getRegistrationIp();
        authMeUser.lastLoginDate = AuthMePlayerImpl.toInstant(lastLoginMillis);
        authMeUser.lastLoginIpAddress = AuthMePlayerImpl.nullIfDefault(playerAuth.getLastIp(), "127.0.0.1");
        return Optional.of(authMeUser);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Optional<UUID> getUuid() {
        return Optional.ofNullable(this.uuid);
    }

    @Override
    public Optional<String> getEmail() {
        return Optional.ofNullable(this.email);
    }

    @Override
    public Instant getRegistrationDate() {
        return this.registrationDate;
    }

    @Override
    public Optional<String> getRegistrationIpAddress() {
        return Optional.ofNullable(this.registrationIpAddress);
    }

    @Override
    public Optional<Instant> getLastLoginDate() {
        return Optional.ofNullable(this.lastLoginDate);
    }

    @Override
    public Optional<String> getLastLoginIpAddress() {
        return Optional.ofNullable(this.lastLoginIpAddress);
    }

    private static Instant toInstant(Long epochMillis) {
        return epochMillis == null ? null : Instant.ofEpochMilli(epochMillis);
    }

    private static <T> T nullIfDefault(T value, T defaultValue) {
        return defaultValue.equals(value) ? null : (T)value;
    }
}

