/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme;

import com.google.common.base.Throwables;
import fr.xephi.authme.output.LogLevel;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.PluginSettings;
import fr.xephi.authme.settings.properties.SecuritySettings;
import fr.xephi.authme.util.ExceptionUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ConsoleLogger {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final DateTimeFormatter DATE_FORMAT = new DateTimeFormatterBuilder().appendLiteral('[').appendPattern("MM-dd HH:mm:ss").appendLiteral(']').toFormatter();
    private static File logFile;
    private static Logger logger;
    private static OutputStreamWriter fileWriter;
    private final String name;
    private LogLevel logLevel = LogLevel.INFO;

    public ConsoleLogger(String name) {
        this.name = name;
    }

    public static void initialize(Logger logger, File logFile) {
        ConsoleLogger.logger = logger;
        ConsoleLogger.logFile = logFile;
    }

    public static void initializeSharedSettings(Settings settings) {
        boolean useLogging = (Boolean)settings.getProperty(SecuritySettings.USE_LOGGING);
        if (useLogging) {
            ConsoleLogger.initializeFileWriter();
        } else {
            ConsoleLogger.closeFileWriter();
        }
    }

    public void initializeSettings(Settings settings) {
        this.logLevel = (LogLevel)((Object)settings.getProperty(PluginSettings.LOG_LEVEL));
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public String getName() {
        return this.name;
    }

    public void warning(String message) {
        logger.warning(message);
        ConsoleLogger.writeLog("[WARN] " + message);
    }

    public void logException(String message, Throwable th) {
        this.warning(message + " " + ExceptionUtils.formatException(th));
        ConsoleLogger.writeLog(Throwables.getStackTraceAsString((Throwable)th));
    }

    public void info(String message) {
        logger.info(message);
        ConsoleLogger.writeLog("[INFO] " + message);
    }

    public void fine(String message) {
        if (this.logLevel.includes(LogLevel.FINE)) {
            logger.info(message);
            ConsoleLogger.writeLog("[FINE] " + message);
        }
    }

    public void debug(String message) {
        if (this.logLevel.includes(LogLevel.DEBUG)) {
            this.logAndWriteWithDebugPrefix(message);
        }
    }

    public void debug(String message, Object param1) {
        if (this.logLevel.includes(LogLevel.DEBUG)) {
            this.debug(message, new Object[]{param1});
        }
    }

    public void debug(String message, Object param1, Object param2) {
        if (this.logLevel.includes(LogLevel.DEBUG)) {
            this.debug(message, new Object[]{param1, param2});
        }
    }

    public void debug(String message, Object ... params) {
        if (this.logLevel.includes(LogLevel.DEBUG)) {
            this.logAndWriteWithDebugPrefix(MessageFormat.format(message, params));
        }
    }

    public void debug(Supplier<String> msgSupplier) {
        if (this.logLevel.includes(LogLevel.DEBUG)) {
            this.logAndWriteWithDebugPrefix(msgSupplier.get());
        }
    }

    private void logAndWriteWithDebugPrefix(String message) {
        String debugMessage = "[DEBUG] " + message;
        logger.info(debugMessage);
        ConsoleLogger.writeLog(debugMessage);
    }

    public static void closeFileWriter() {
        if (fileWriter != null) {
            try {
                fileWriter.flush();
            }
            catch (IOException iOException) {
            }
            finally {
                ConsoleLogger.closeSafely(fileWriter);
                fileWriter = null;
            }
        }
    }

    private static void writeLog(String message) {
        if (fileWriter != null) {
            String dateTime = DATE_FORMAT.format(LocalDateTime.now());
            try {
                fileWriter.write(dateTime);
                fileWriter.write(": ");
                fileWriter.write(message);
                fileWriter.write(NEW_LINE);
                fileWriter.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void closeSafely(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Failed to close resource", e);
            }
        }
    }

    private static void initializeFileWriter() {
        if (fileWriter == null) {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(logFile, true);
                fileWriter = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                ConsoleLogger.closeSafely(fos);
                logger.log(Level.SEVERE, "Failed to create writer to AuthMe log file", e);
            }
        }
    }
}

