/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme;

import ch.jalu.injector.Injector;
import ch.jalu.injector.InjectorBuilder;
import com.google.common.annotations.VisibleForTesting;
import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.api.v3.AuthMeApi;
import fr.xephi.authme.command.CommandHandler;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.initialization.DataFolder;
import fr.xephi.authme.initialization.DataSourceProvider;
import fr.xephi.authme.initialization.OnShutdownPlayerSaver;
import fr.xephi.authme.initialization.OnStartupTasks;
import fr.xephi.authme.initialization.SettingsProvider;
import fr.xephi.authme.initialization.TaskCloser;
import fr.xephi.authme.listener.BlockListener;
import fr.xephi.authme.listener.EntityListener;
import fr.xephi.authme.listener.PlayerListener;
import fr.xephi.authme.listener.PlayerListener111;
import fr.xephi.authme.listener.PlayerListener19;
import fr.xephi.authme.listener.PlayerListener19Spigot;
import fr.xephi.authme.listener.ServerListener;
import fr.xephi.authme.output.ConsoleLoggerFactory;
import fr.xephi.authme.security.crypts.Sha256;
import fr.xephi.authme.service.BackupService;
import fr.xephi.authme.service.BukkitService;
import fr.xephi.authme.service.MigrationService;
import fr.xephi.authme.service.bungeecord.BungeeReceiver;
import fr.xephi.authme.service.yaml.YamlParseException;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.SettingsWarner;
import fr.xephi.authme.settings.properties.SecuritySettings;
import fr.xephi.authme.task.CleanupTask;
import fr.xephi.authme.task.purge.PurgeService;
import fr.xephi.authme.util.ExceptionUtils;
import fr.xephi.authme.util.Utils;
import java.io.File;
import java.util.function.Consumer;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.JavaPluginLoader;
import org.bukkit.scheduler.BukkitScheduler;

public class AuthMe
extends JavaPlugin {
    private static final String PLUGIN_NAME = "AuthMeReloaded";
    private static final String LOG_FILENAME = "authme.log";
    private static final int CLEANUP_INTERVAL = 6000;
    private static String pluginVersion = "N/D";
    private static String pluginBuildNumber = "Unknown";
    private CommandHandler commandHandler;
    private Settings settings;
    private DataSource database;
    private BukkitService bukkitService;
    private Injector injector;
    private BackupService backupService;
    private ConsoleLogger logger;

    public AuthMe() {
    }

    @VisibleForTesting
    AuthMe(JavaPluginLoader loader, PluginDescriptionFile description, File dataFolder, File file) {
        super(loader, description, dataFolder, file);
    }

    public static String getPluginName() {
        return PLUGIN_NAME;
    }

    public static String getPluginVersion() {
        return pluginVersion;
    }

    public static String getPluginBuildNumber() {
        return pluginBuildNumber;
    }

    public void onEnable() {
        AuthMe.loadPluginInfo(this.getDescription().getVersion());
        ConsoleLogger.initialize(this.getLogger(), new File(this.getDataFolder(), LOG_FILENAME));
        this.logger = ConsoleLoggerFactory.get(AuthMe.class);
        if (!Utils.isClassLoaded("org.spigotmc.event.player.PlayerSpawnLocationEvent") || !Utils.isClassLoaded("org.bukkit.event.player.PlayerInteractAtEntityEvent")) {
            this.logger.warning("You are running an unsupported server version (" + this.getServerNameVersionSafe() + "). AuthMe requires Spigot 1.8.X or later!");
            this.stopOrUnload();
            return;
        }
        if (this.getServer().getPluginManager().isPluginEnabled("AuthMeBridge")) {
            this.logger.warning("Detected AuthMeBridge, support for it has been dropped as it was causing exploit issues, please use AuthMeBungee instead! Aborting!");
            this.stopOrUnload();
            return;
        }
        try {
            this.initialize();
        }
        catch (Throwable th) {
            YamlParseException yamlParseException = ExceptionUtils.findThrowableInCause(YamlParseException.class, th);
            if (yamlParseException == null) {
                this.logger.logException("Aborting initialization of AuthMe:", th);
                th.printStackTrace();
            } else {
                this.logger.logException("File '" + yamlParseException.getFile() + "' contains invalid YAML. Please run its contents through http://yamllint.com", yamlParseException);
            }
            this.stopOrUnload();
            return;
        }
        ((SettingsWarner)this.injector.getSingleton(SettingsWarner.class)).logWarningsForMisconfigurations();
        CleanupTask cleanupTask = (CleanupTask)((Object)this.injector.getSingleton(CleanupTask.class));
        cleanupTask.runTaskTimerAsynchronously((Plugin)this, 6000L, 6000L);
        this.backupService.doBackup(BackupService.BackupCause.START);
        OnStartupTasks.sendMetrics(this, this.settings);
        this.logger.info("AuthMe " + AuthMe.getPluginVersion() + " build n." + AuthMe.getPluginBuildNumber() + " successfully enabled!");
        PurgeService purgeService = (PurgeService)this.injector.getSingleton(PurgeService.class);
        purgeService.runAutoPurge();
    }

    private static void loadPluginInfo(String versionRaw) {
        int index = versionRaw.lastIndexOf("-");
        if (index != -1) {
            pluginVersion = versionRaw.substring(0, index);
            pluginBuildNumber = versionRaw.substring(index + 1);
            if (pluginBuildNumber.startsWith("b")) {
                pluginBuildNumber = pluginBuildNumber.substring(1);
            }
        }
    }

    private void initialize() {
        this.getDataFolder().mkdir();
        this.injector = new InjectorBuilder().addDefaultHandlers("fr.xephi.authme").create();
        this.injector.register(AuthMe.class, (Object)this);
        this.injector.register(Server.class, (Object)this.getServer());
        this.injector.register(PluginManager.class, (Object)this.getServer().getPluginManager());
        this.injector.register(BukkitScheduler.class, (Object)this.getServer().getScheduler());
        this.injector.provide(DataFolder.class, (Object)this.getDataFolder());
        this.injector.registerProvider(Settings.class, SettingsProvider.class);
        this.injector.registerProvider(DataSource.class, DataSourceProvider.class);
        this.settings = (Settings)((Object)this.injector.getSingleton(Settings.class));
        ConsoleLoggerFactory.reloadSettings(this.settings);
        OnStartupTasks.setupConsoleFilter(this.getLogger());
        this.instantiateServices(this.injector);
        MigrationService.changePlainTextToSha256(this.settings, this.database, new Sha256());
        if (this.bukkitService.getOnlinePlayers().isEmpty()) {
            this.database.purgeLogged();
        }
        this.registerEventListeners(this.injector);
        OnStartupTasks onStartupTasks = (OnStartupTasks)this.injector.newInstance(OnStartupTasks.class);
        onStartupTasks.scheduleRecallEmailTask();
    }

    void instantiateServices(Injector injector) {
        this.database = (DataSource)injector.getSingleton(DataSource.class);
        this.bukkitService = (BukkitService)injector.getSingleton(BukkitService.class);
        this.commandHandler = (CommandHandler)injector.getSingleton(CommandHandler.class);
        this.backupService = (BackupService)injector.getSingleton(BackupService.class);
        injector.getSingleton(BungeeReceiver.class);
        injector.getSingleton(AuthMeApi.class);
    }

    void registerEventListeners(Injector injector) {
        PluginManager pluginManager = this.getServer().getPluginManager();
        pluginManager.registerEvents((Listener)injector.getSingleton(PlayerListener.class), (Plugin)this);
        pluginManager.registerEvents((Listener)injector.getSingleton(BlockListener.class), (Plugin)this);
        pluginManager.registerEvents((Listener)injector.getSingleton(EntityListener.class), (Plugin)this);
        pluginManager.registerEvents((Listener)injector.getSingleton(ServerListener.class), (Plugin)this);
        if (Utils.isClassLoaded("org.bukkit.event.player.PlayerSwapHandItemsEvent")) {
            pluginManager.registerEvents((Listener)injector.getSingleton(PlayerListener19.class), (Plugin)this);
        }
        if (Utils.isClassLoaded("org.spigotmc.event.player.PlayerSpawnLocationEvent")) {
            pluginManager.registerEvents((Listener)injector.getSingleton(PlayerListener19Spigot.class), (Plugin)this);
        }
        if (Utils.isClassLoaded("org.bukkit.event.entity.EntityAirChangeEvent")) {
            pluginManager.registerEvents((Listener)injector.getSingleton(PlayerListener111.class), (Plugin)this);
        }
    }

    public void stopOrUnload() {
        if (this.settings == null || ((Boolean)this.settings.getProperty(SecuritySettings.STOP_SERVER_ON_PROBLEM)).booleanValue()) {
            this.getLogger().warning("THE SERVER IS GOING TO SHUT DOWN AS DEFINED IN THE CONFIGURATION!");
            this.setEnabled(false);
            this.getServer().shutdown();
        } else {
            this.setEnabled(false);
        }
    }

    public void onDisable() {
        OnShutdownPlayerSaver onShutdownPlayerSaver;
        OnShutdownPlayerSaver onShutdownPlayerSaver2 = onShutdownPlayerSaver = this.injector == null ? null : (OnShutdownPlayerSaver)this.injector.createIfHasDependencies(OnShutdownPlayerSaver.class);
        if (onShutdownPlayerSaver != null) {
            onShutdownPlayerSaver.saveAllPlayers();
        }
        if (this.backupService != null) {
            this.backupService.doBackup(BackupService.BackupCause.STOP);
        }
        new TaskCloser(this, this.database).run();
        Consumer<String> infoLogMethod = this.logger == null ? this.getLogger()::info : this.logger::info;
        infoLogMethod.accept("AuthMe " + this.getDescription().getVersion() + " disabled!");
        ConsoleLogger.closeFileWriter();
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        if (this.commandHandler == null) {
            this.getLogger().severe("AuthMe command handler is not available");
            return false;
        }
        return this.commandHandler.processCommand(sender, commandLabel, args);
    }

    private String getServerNameVersionSafe() {
        try {
            Server server = this.getServer();
            return server.getName() + " v. " + server.getVersion();
        }
        catch (Throwable ignore) {
            return "-";
        }
    }
}

